<?php

namespace Database\Seeders;

use Botble\Base\Supports\BaseSeeder;
use Botble\Gallery\Database\Traits\HasGallerySeeder;
use Botble\Gallery\Models\Gallery;
use Botble\Slug\Models\Slug;

class GallerySeeder extends BaseSeeder
{
    use HasGallerySeeder;

    public function run(): void
    {
        Slug::query()->where('reference_type', Gallery::class)->delete();

        $this->uploadFiles('galleries');

        $galleries = [
            [
                'name' => 'Perfect',
            ],
            [
                'name' => 'New Day',
            ],
            [
                'name' => 'Happy Day',
            ],
            [
                'name' => 'Nature',
            ],
            [
                'name' => 'Morning',
            ],
            [
                'name' => 'Photography',
            ],
        ];

        $descriptions = [
            'A beautiful landscape captured in perfect lighting',
            'Nature at its finest moment',
            'Stunning photography showcasing natural beauty',
            'Peaceful scenery with vibrant colors',
            'Artistic composition of natural elements',
            'Breathtaking view of the great outdoors',
            'Captivating moment frozen in time',
            'Serene environment with perfect harmony',
            'Magnificent display of natural wonders',
            'Inspiring view that touches the soul',
        ];

        $images = [];
        for ($i = 0; $i < 10; $i++) {
            $images[] = [
                'img' => $this->filePath('galleries/' . ($i + 1) . '.jpg'),
                'description' => $descriptions[$i],
            ];
        }

        foreach ($galleries as $index => &$item) {
            $item['image'] = $this->filePath('galleries/' . ($index + 1) . '.jpg');
            $item['is_featured'] = true;
        }

        $this->createGalleries($galleries, $images);
    }
}
